#ifndef METHODS_TABLE_H
#define METHODS_TABLE_H

#include ".\pythoninclude\Python.h"
#include "console.h"
//#include "hooks.h"
#include "vector3_type.h"
#include "vector3.h"
#include "player.h"
#include "preset.h"
#include "bhs.h"
#include "extra.h"
#include "beacons_c4.h"
#include "scriptsmanager.h"
#include "scripts_py.h"
#include "vehicle.h"

static PyMethodDef ScriptsDllMethods[] = { // this array is the table that contains all the
    {"consoleout", (PyCFunction)scriptsdll_consoleout, METH_VARARGS, // functions/methods of the scriptsdll module
     "Send text to the FDS' console."},
	{"consolein", (PyCFunction)scriptsdll_consolein, METH_VARARGS,
     "Execute an FDS console command."},
	 {"setposition", (PyCFunction)scriptsdll_setposition, METH_VARARGS,
     "Set the position of a GameObject"},
	 {"getposition", scriptsdll_getposition, METH_VARARGS,
     "Get the position of a GameObject"},
	 {"getgameobj", scriptsdll_getgameobj, METH_VARARGS,
     "Gets the GameObject ID of a PlayerID"},
	 {"getplayerid", scriptsdll_getplayerid, METH_VARARGS,
     "Get the PlayerID of a player"},
	{"getplayername", scriptsdll_getplayername, METH_VARARGS,
     "Get the name of a player"},
	 {"getplayernamebyid", scriptsdll_getplayernamebyid, METH_VARARGS,
     "Get the name of a player by player ID"},
	{"changeteam", (PyCFunction)scriptsdll_changeteam, METH_VARARGS,
     "Change the team of a player."},
	 {"changeteambyid", (PyCFunction)scriptsdll_changeteambyid, METH_VARARGS,
     "Change the team of a player by player ID"},
	 {"getplayercount", scriptsdll_getplayercount, METH_VARARGS,
     "Get the total player count"},
	 {"getteamplayercount", scriptsdll_getteamplayercount, METH_VARARGS,
     "Get the player count of a specified team"},
	 {"getteam", scriptsdll_getteam, METH_VARARGS,
     "Get the team of a player by playerID"},
	 {"getrank", scriptsdll_getrank, METH_VARARGS,
     "Get the rank of a player by playerID"},
	{"getkills", scriptsdll_getkills, METH_VARARGS,
     "Get the kills count of a player by playerID"},
	 {"getdeaths", scriptsdll_getdeaths, METH_VARARGS,
     "Get the deaths count of a player by playerID"},
	{"getscore", scriptsdll_getscore, METH_VARARGS,
     "Get the score of a player by playerID"},
	 {"getmoney", scriptsdll_getmoney, METH_VARARGS,
     "Get the money of a player by playerID"},
	{"getkd", scriptsdll_getkd, METH_VARARGS,
     "Get the kill/death ratio of a player by playerID"},
	 {"getpartname", scriptsdll_getpartname, METH_VARARGS,
     "Get a GameObject by part of a playername"},
	 {"getpartnames", scriptsdll_getpartnames, METH_VARARGS,
     "Get the count of players with string in their name"},
	 {"getgameobjbyplayername", scriptsdll_getgameobjbyplayername, METH_VARARGS,
     "Get a GameObject by player name"},
	 {"purchaseitem", scriptsdll_purchaseitem, METH_VARARGS,
     "Deducts an amount of credits from a player via GameObject"},
	 {"setladderpoints", (PyCFunction)scriptsdll_setladderpoints, METH_VARARGS,
     "Set the ladder points of a player"},
	 {"setrung", (PyCFunction)scriptsdll_setrung, METH_VARARGS,
     "Set the rung of a player"},
	 {"setmoney", (PyCFunction)scriptsdll_setmoney, METH_VARARGS,
     "Set the amount of money of a player"},
	 {"setscore", (PyCFunction)scriptsdll_setscore, METH_VARARGS,
     "Set the score of a player"},
	 {"findfirstplayer", scriptsdll_findfirstplayer, METH_VARARGS,
     "Find the first player on a team"},
	 {"changeplayerteam", scriptsdll_changeplayerteam, METH_VARARGS,
     "Change the team of a player"},
	 {"getteamscore", scriptsdll_getteamscore, METH_VARARGS,
     "Get the score of a team"},
	 {"tallyteamsize", scriptsdll_tallyteamsize, METH_VARARGS,
     "Tally team size"},
	{"sendcustomallplayers", (PyCFunction)scriptsdll_sendcustomallplayers, METH_VARARGS,
     "Send a custom to all players"},
	 {"stealteamcredits", scriptsdll_stealteamcredits, METH_VARARGS,
     "Steal a percentage of credits from a team"},
	 {"getteamcredits", scriptsdll_getteamcredits, METH_VARARGS,
     "Get the amount of credits of a team"},
	 {"changeteam2", (PyCFunction)scriptsdll_changeteam2, METH_VARARGS,
     "Change the team of a player, has some extra fixes"},
	 {"getplayertype", scriptsdll_getplayertype, METH_VARARGS,
     "Get the type/team of a player"},
	 {"getteamcost", scriptsdll_getteamcost, METH_VARARGS,
     "Get cost of a preset for a team"},
	 {"getcost", scriptsdll_getcost, METH_VARARGS,
     "Get the cost of a preset"},
	 {"setenlisted", (PyCFunction)scriptsdll_setenlisted, METH_VARARGS,
     "Set enlisted"},
	 {"setbeacon", (PyCFunction)scriptsdll_setbeacon, METH_VARARGS,
     "Set beacon"},
	 {"setrefill", (PyCFunction)scriptsdll_setrefill, METH_VARARGS,
     "Set refill"},
	 {"setpreset", (PyCFunction)scriptsdll_setpreset, METH_VARARGS,
     "Set beacon"},
	 {"setalternate", (PyCFunction)scriptsdll_setalternate, METH_VARARGS,
     "Set an alternate"},
	 {"disableenlisted", (PyCFunction)scriptsdll_disableenlisted, METH_VARARGS,
     "Disable an enlisted soldier"},
	 {"disablepreset", (PyCFunction)scriptsdll_disablepreset, METH_VARARGS,
     "Disable a preset"},
	 {"disableenlistedbyname", (PyCFunction)scriptsdll_disableenlistedbyname, METH_VARARGS,
     "Disable an enlisted soldier by name"},
	 {"disablepresetbyname", (PyCFunction)scriptsdll_disablepresetbyname, METH_VARARGS,
     "Disable a preset by name"},
	 {"disableallgroundvehicles", (PyCFunction)scriptsdll_disableallgroundvehicles, METH_VARARGS,
     "Disable all ground vehicles for a team"},
	 {"disableallflyingvehicles", (PyCFunction)scriptsdll_disableallflyingvehicles, METH_VARARGS,
     "Disable all flying vehicles for a team"},
	 {"getteamicon", scriptsdll_getteamicon, METH_VARARGS,
     "Get preset icon for team"},
	 {"geticon", scriptsdll_geticon, METH_VARARGS,
     "Get preset icon"},
	 {"createobject", scriptsdll_createobject, METH_VARARGS,
     "Create an object by preset name and position"},
	 {"destroyobject", (PyCFunction)scriptsdll_destroyobject, METH_VARARGS,
     "Destroy an object"},
	 {"getpresetname", scriptsdll_getpresetname, METH_VARARGS,
     "Get the preset name of a GameObject"},
	 {"enablevehicletransitions", (PyCFunction)scriptsdll_enablevehicletransitions, METH_VARARGS,
     "Turn vehicle transitions on or off for a vehicle"},
	 {"setmodel", (PyCFunction)scriptsdll_setmodel, METH_VARARGS,
     "Set the model of an object"},
	 {"gotolocation", (PyCFunction)scriptsdll_gotolocation, METH_VARARGS,
     "Tell a bot to go to a location"},
	 {"gotoobject", (PyCFunction)scriptsdll_gotoobject, METH_VARARGS,
     "Tell a bot to go to an object"},
	 {"disablephysicalcollisions", (PyCFunction)scriptsdll_disablephysicalcollisions, METH_VARARGS,
     "Disable physical collisions"},
	 {"enablecollisions", (PyCFunction)scriptsdll_enablecollisions, METH_VARARGS,
     "Enable (physical) collisions"},
	 {"randombuilding", scriptsdll_randombuilding, METH_NOARGS,
     "Get a random building GameObject from a random team"},
	 {"getcurrentmap", scriptsdll_getcurrentmap, METH_NOARGS,
     "Get the current map"},
	 {"getnextmap", scriptsdll_getnextmap, METH_NOARGS,
     "Get the next map"},
	 {"applydamage", (PyCFunction)scriptsdll_applydamage, METH_VARARGS,
     "Apply damage with an optional damager"},
	{"getfacing", scriptsdll_getfacing, METH_VARARGS,
     "Get the facing of a GameObject"},
	 {"setfacing", (PyCFunction)scriptsdll_setfacing, METH_VARARGS,
     "Set the facing of a GameObject"},
	{"setclouds", (PyCFunction)scriptsdll_setclouds, METH_VARARGS,
     "Set the clouds"},
	 {"setash", (PyCFunction)scriptsdll_setash, METH_VARARGS,
     "Set ash"},
	 {"setsnow", (PyCFunction)scriptsdll_setsnow, METH_VARARGS,
     "Set snow"},
	 {"setrain", (PyCFunction)scriptsdll_setrain, METH_VARARGS,
     "Set rain"},
	 {"attachscript", (PyCFunction)scriptsdll_attachscript, METH_VARARGS,
     "Attach a script to a GameObject"},
	{"createobjectatbone", scriptsdll_createobjectatbone, METH_VARARGS,
     "Creates an object at the bone of another GameObject"},
	 {"createscriptzone", scriptsdll_createscriptzone, METH_VARARGS,
     "Creates a script zone"},
	 {"attachtoobjectbone", (PyCFunction)scriptsdll_attachtoobjectbone, METH_VARARGS,
     "Attach an object to the bone of another GameObject"},
	 {"displayhealthbar", (PyCFunction)scriptsdll_displayhealthbar, METH_VARARGS,
     "Turn showing a health bar on/off for certain GameObjects"},
	{"registerscript", (PyCFunction)ScriptManager::registerscript, METH_VARARGS,
     "Registers a Python script via Python"},
	{"destroyscript", (PyCFunction)scriptsdll_destroyscript, METH_VARARGS,
     "Destroy a Python script"},
	 {"starttimer", (PyCFunction)scriptsdll_starttimer, METH_VARARGS,
     "Start a timer for a Python script"},
	 {"getfloatparameter", scriptsdll_getfloatparameter, METH_VARARGS,
     "Get the value of a float parameter of a script"},
	 {"getintparameter", scriptsdll_getintparameter, METH_VARARGS,
     "Get the value of an int parameter of a script"},
	 {"getstringparameter", scriptsdll_getstringparameter, METH_VARARGS,
     "Get the value of a string parameter of a script"},
	 {"Request_Serial", (PyCFunction)scriptsdll_requestserial, METH_VARARGS,
     "Request a serial response, this will trigger all serial hooks"},
	 {"cPlayer", scriptsdll_cplayer, METH_VARARGS,
     "Returns a dict containing all the cPlayer info for a player"},
	 {"The_Game", scriptsdll_thegame, METH_NOARGS,
     "Returns a dict containing all The_Game() info"},
	 {"Get_All_Objects", scriptsdll_getallobjects, METH_NOARGS,
     "Get a list of all objects ingame"},
	 {"Get_Rotation", scriptsdll_getrotation, METH_NOARGS,
     "Get a list of all maps in rotation"},
	 {"Get_All_Vehicles", scriptsdll_getallvehicles, METH_NOARGS,
     "Get a list of all vehicle objects ingame"},
	 {"Get_All_Players", scriptsdll_getallplayers, METH_NOARGS,
     "Get a list of playerIDs for all players ingame"},
	 {"Get_All_Buildings", scriptsdll_getallbuildings, METH_NOARGS,
     "Get a list of all building objects ingame"},
	 {"Get_Vehicle_Occupant_Count", scriptsdll_getvehicleoccupantcount, METH_NOARGS,
     "Get the count of occupants of a vehicle"},
	 {"Get_Vehicle_Occupant", scriptsdll_getvehicleoccupant, METH_NOARGS,
     "Get an occupant in a certain seat of a vehicle"},
	 {"Get_Vehicle_Driver", scriptsdll_getvehicledriver, METH_NOARGS,
     "Get the driver of a vehicle"},
	 {"Force_Occupant_Exit", (PyCFunction)scriptsdll_forceoccupantexit, METH_NOARGS,
     "Forces an occupant in a certain seat to exit a vehicle"},
	 {"Force_Occupants_Exit", (PyCFunction)scriptsdll_forceoccupantsexit, METH_NOARGS,
     "Forces all occupants of a vehicle to exit"},
	 {"Get_Vehicle_Return", scriptsdll_getvehiclereturn, METH_NOARGS,
     "Get the vehicle a player is driving, returns player if not in vehicle"},
	 {"Create_2D_Sound_Player", (PyCFunction)scriptsdll_create2dsoundplayer, METH_VARARGS,
     "Creates a 2D sound for a player"},
	 {"Create_2D_WAV_Sound_Player", (PyCFunction)scriptsdll_create2dwavsoundplayer, METH_VARARGS,
     "Creates a 2D sound for a team"},
	 {"Create_2D_Sound_Team", (PyCFunction)scriptsdll_create2dsoundteam, METH_VARARGS,
     "Creates a 2D sound for a team"},
	 {"Create_2D_WAV_Sound_Team", (PyCFunction)scriptsdll_create2dwavsoundteam, METH_VARARGS,
     "Creates a 2D WAV sound for a team"},

    {NULL, NULL, 0, NULL} // sentinel 
};

static PyModuleDef ScriptDllModule = { //This struct contains info about the scriptsdll module
    PyModuleDef_HEAD_INIT, "scriptsdll", NULL, -1, ScriptsDllMethods,
    NULL, NULL, NULL, NULL
};

static PyObject*
PyInit_scriptsdll(void)
{
	PyObject* m;

	if (PyType_Ready(&Vector3ObjectType) < 0)
    return NULL;

	m = PyModule_Create(&ScriptDllModule);
	if (m == NULL)
        return NULL;
	Py_INCREF(&Vector3ObjectType);
    PyModule_AddObject(m, "Vector3", (PyObject *)&Vector3ObjectType);

	return m;
}


#endif METHODS_TABLE_H